// config: norepeat noautolaunch

#include "GetObjects.js"
#include "WaitForDialogDone.js"

function DoNetwork()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	
	if ( !GetObjects( objectpicker ) )
		return;

	var objects = objectpicker.objects;
	objects.sortBySelectionOrder();
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.showUI( 'options' );
	moi.ui.endUIUpdate();	
		
	var factory = moi.command.createFactory( 'network' );
	factory.setInput( 0, objects );
	
	if ( !factory.canDoCoonsPatch )
		moi.ui.commandUI.RemoveExactOption();
	
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'mode', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'tolerance', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'numpoints', 'value', factory.getInput(6) );	
	factory.disableUpdate( false );
	factory.update();
	
	if ( !WaitForDialogDone() )
		return;
	
	factory.commit();
}

DoNetwork();
